//Installer written by Scrivener07 @ thenexusforums.com
using System;
using fomm.Scripting;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;
using System.Windows.Forms;
using System.Globalization;

class Script : FalloutNewVegasBaseScript {
//Declarations
	const string title = "A Quality World Map v8.0";
	static Form mainInstallForm;		
	static PictureBox backgroundPicture;
	static PictureBox exitButton;
	static PictureBox installButton;
	static PictureBox previewButton;
	static PictureBox backButton;
	
	//standard map declared	
	static Panel installStandardRoadsPanel;
	static Label standardLabel;
	static Label stdAllLabel;
	static PictureBox installstdAllButton;
	static Label stdMainLabel;
	static PictureBox installstdMainButton;
	
	//classic map declared	
	static Panel installClassicRoadsPanel;
	static Label classicLabel;
	static Label clsAllLabel;
	static PictureBox installclsAllButton;
	static Label clsMainLabel;
	static PictureBox installclsMainButton;

	//patches declared
	static Panel installPatchesPanel;
	static Label patchesLabel;
	static Label patchNoLabel;
	static PictureBox patchNoButton;
	static Label patchYesLabel;
	static PictureBox patchYesButton;

	//clouds patch declared
	static Panel installCloudPatchPanel;
	static Label cloudsLabel;
	static Label cloudsNoLabel;
	static PictureBox cloudsNoButton;
	static Label cloudsYesLabel;
	static PictureBox cloudsYesButton;	

	//preview declared
	static Form previewForm;
	static Panel previewPanel;
	static int previewSelected;
	static int DEFAULT_PREVIEW_IMAGE = 1;
	static PictureBox previewMapBox;	
	static Image imageVanillaMap;
	static PictureBox previewVanillaMap;	
	static Image imageAllRoads;	
	static PictureBox previewAllRoadsMap;	
	static Image imageMainRoads;
	static PictureBox previewMainRoadsMap;		
	static Image imageClassicMap;
	static PictureBox previewClassicMap;	
	static Image imageVanillaClouds;
	static PictureBox previewVanillaClouds;	
	static Image imageClearMap;
	static PictureBox previewClearMap;
	static Label previewVanillaMapLabel;
	static Label previewAllRoadsMapLabel;
	static Label previewMainRoadsMapLabel;
	static Label previewClassicMapLabel;
	static Label previewVanillaCloudsLabel;
	static Label previewClearMapLabel;
	
	//images
	static Image imageChecked;
	static Image imageUnchecked;	
	static Image imageBackground;
	static Image imageInstall;
	static Image imageInstallHi;
	static Image imageExit;
	static Image imageExitHi;
	static Image imagePreview;
	static Image imagePreviewHi;
	static Image imageBack;
	static Image imageBackHi;

	//Sounds	
	static System.Media.SoundPlayer hoverPlayer;
	static System.Media.SoundPlayer acceptPlayer;
	static System.Media.SoundPlayer denyPlayer;
	static System.Media.SoundPlayer selectPlayer;

	//Install	
	static bool install;	
	static int categorySelected;
//	static int patchSelected;	
	static int cloudSelected;	
	static int DEFAULT_CATEGORY_ICON = 1;
//	static int DEFAULT_PATCH_ICON = 3;
	static int DEFAULT_CLOUD_ICON = 4;
	
//------------------------------------------------------------------
//Do this when mod is activated
//------------------------------------------------------------------	
	public static bool OnActivate() {	
		setDefaults();
		InitializeComponents();
		mainInstallForm.ShowDialog(); 
			if (install) {		
				installFiles();
			}	
		return install;
	}
	
//------------------------------------------------------------------
//Install Instructions	
//------------------------------------------------------------------
	static void setDefaults() {
		categorySelected = DEFAULT_CATEGORY_ICON;
	//	patchSelected = DEFAULT_PATCH_ICON;
		cloudSelected = DEFAULT_CLOUD_ICON;
		previewSelected = DEFAULT_PREVIEW_IMAGE;
	}
	static void installFiles() {
		installModFiles();
		installReadmeFiles();
	}
	static void installModFiles() {
		if (categorySelected == 1) {//Standard ALL ROADS NO PATCH
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.0.0.dds", "Textures/terrain/Tamriel/tamriel.32.0.0.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.0.32.dds", "Textures/terrain/Tamriel/tamriel.32.0.32.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.0.-32.dds", "Textures/terrain/Tamriel/tamriel.32.0.-32.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.0.-64.dds", "Textures/terrain/Tamriel/tamriel.32.0.-64.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.32.0.dds", "Textures/terrain/Tamriel/tamriel.32.32.0.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.-32.0.dds", "Textures/terrain/Tamriel/tamriel.32.-32.0.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.32.32.dds", "Textures/terrain/Tamriel/tamriel.32.32.32.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.32.-32.dds", "Textures/terrain/Tamriel/tamriel.32.32.-32.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.-32.32.dds", "Textures/terrain/Tamriel/tamriel.32.-32.32.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.-32.-32.dds", "Textures/terrain/Tamriel/tamriel.32.-32.-32.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.32.-64.dds", "Textures/terrain/Tamriel/tamriel.32.32.-64.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.-32.-64.dds", "Textures/terrain/Tamriel/tamriel.32.-32.-64.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.-64.0.dds", "Textures/terrain/Tamriel/tamriel.32.-64.0.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.-64.32.dds", "Textures/terrain/Tamriel/tamriel.32.-64.32.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.-64.-32.dds", "Textures/terrain/Tamriel/tamriel.32.-64.-32.dds");
			CopyDataFile("Map Standard All Roads/Textures/terrain/Tamriel/tamriel.32.-64.-64.dds", "Textures/terrain/Tamriel/tamriel.32.-64.-64.dds");
		} 
		if (categorySelected == 12) {//Standard MAIN ROADS NO PATCH
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.0.0.dds", "Textures/terrain/Tamriel/tamriel.32.0.0.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.0.32.dds", "Textures/terrain/Tamriel/tamriel.32.0.32.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.0.-32.dds", "Textures/terrain/Tamriel/tamriel.32.0.-32.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.0.-64.dds", "Textures/terrain/Tamriel/tamriel.32.0.-64.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.32.0.dds", "Textures/terrain/Tamriel/tamriel.32.32.0.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.-32.0.dds", "Textures/terrain/Tamriel/tamriel.32.-32.0.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.32.32.dds", "Textures/terrain/Tamriel/tamriel.32.32.32.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.32.-32.dds", "Textures/terrain/Tamriel/tamriel.32.32.-32.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.-32.32.dds", "Textures/terrain/Tamriel/tamriel.32.-32.32.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.-32.-32.dds", "Textures/terrain/Tamriel/tamriel.32.-32.-32.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.32.-64.dds", "Textures/terrain/Tamriel/tamriel.32.32.-64.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.-32.-64.dds", "Textures/terrain/Tamriel/tamriel.32.-32.-64.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.-64.0.dds", "Textures/terrain/Tamriel/tamriel.32.-64.0.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.-64.32.dds", "Textures/terrain/Tamriel/tamriel.32.-64.32.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.-64.-32.dds", "Textures/terrain/Tamriel/tamriel.32.-64.-32.dds");
			CopyDataFile("Map Standard Main Roads/Textures/terrain/Tamriel/tamriel.32.-64.-64.dds", "Textures/terrain/Tamriel/tamriel.32.-64.-64.dds");
			} 
	
		if (categorySelected == 2) {//Classic ALL ROADS
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.0.0.dds", "Textures/terrain/Tamriel/tamriel.32.0.0.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.0.32.dds", "Textures/terrain/Tamriel/tamriel.32.0.32.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.0.-32.dds", "Textures/terrain/Tamriel/tamriel.32.0.-32.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.0.-64.dds", "Textures/terrain/Tamriel/tamriel.32.0.-64.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.32.0.dds", "Textures/terrain/Tamriel/tamriel.32.32.0.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.-32.0.dds", "Textures/terrain/Tamriel/tamriel.32.-32.0.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.32.32.dds", "Textures/terrain/Tamriel/tamriel.32.32.32.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.32.-32.dds", "Textures/terrain/Tamriel/tamriel.32.32.-32.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.-32.32.dds", "Textures/terrain/Tamriel/tamriel.32.-32.32.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.-32.-32.dds", "Textures/terrain/Tamriel/tamriel.32.-32.-32.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.32.-64.dds", "Textures/terrain/Tamriel/tamriel.32.32.-64.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.-32.-64.dds", "Textures/terrain/Tamriel/tamriel.32.-32.-64.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.-64.0.dds", "Textures/terrain/Tamriel/tamriel.32.-64.0.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.-64.32.dds", "Textures/terrain/Tamriel/tamriel.32.-64.32.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.-64.-32.dds", "Textures/terrain/Tamriel/tamriel.32.-64.-32.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/tamriel.32.-64.-64.dds", "Textures/terrain/Tamriel/tamriel.32.-64.-64.dds");
			CopyDataFile("Map Classic All Roads/Textures/terrain/Tamriel/objects/tamriel.objects.dds", "Textures/terrain/Tamriel/objects/tamriel.objects.dds");
			} 			
		if (categorySelected == 22) {//Classic MAIN ROADS
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.0.0.dds", "Textures/terrain/Tamriel/tamriel.32.0.0.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.0.32.dds", "Textures/terrain/Tamriel/tamriel.32.0.32.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.0.-32.dds", "Textures/terrain/Tamriel/tamriel.32.0.-32.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.0.-64.dds", "Textures/terrain/Tamriel/tamriel.32.0.-64.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.32.0.dds", "Textures/terrain/Tamriel/tamriel.32.32.0.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.-32.0.dds", "Textures/terrain/Tamriel/tamriel.32.-32.0.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.32.32.dds", "Textures/terrain/Tamriel/tamriel.32.32.32.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.32.-32.dds", "Textures/terrain/Tamriel/tamriel.32.32.-32.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.-32.32.dds", "Textures/terrain/Tamriel/tamriel.32.-32.32.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.-32.-32.dds", "Textures/terrain/Tamriel/tamriel.32.-32.-32.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.32.-64.dds", "Textures/terrain/Tamriel/tamriel.32.32.-64.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.-32.-64.dds", "Textures/terrain/Tamriel/tamriel.32.-32.-64.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.-64.0.dds", "Textures/terrain/Tamriel/tamriel.32.-64.0.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.-64.32.dds", "Textures/terrain/Tamriel/tamriel.32.-64.32.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.-64.-32.dds", "Textures/terrain/Tamriel/tamriel.32.-64.-32.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/tamriel.32.-64.-64.dds", "Textures/terrain/Tamriel/tamriel.32.-64.-64.dds");
			CopyDataFile("Map Classic Main Roads/Textures/terrain/Tamriel/objects/tamriel.objects.dds", "Textures/terrain/Tamriel/objects/tamriel.objects.dds");
			} 
			
		if (categorySelected == 3) {//Standard ALL ROADS HiRes
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.0.0.dds", "Textures/terrain/Tamriel/tamriel.32.0.0.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.0.-32.dds", "Textures/terrain/Tamriel/tamriel.32.0.-32.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-32.-32.dds", "Textures/terrain/Tamriel/tamriel.32.-32.-32.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.0.32.dds", "Textures/terrain/Tamriel/tamriel.32.0.32.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.0.-64.dds", "Textures/terrain/Tamriel/tamriel.32.0.-64.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.32.0.dds", "Textures/terrain/Tamriel/tamriel.32.32.0.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-32.0.dds", "Textures/terrain/Tamriel/tamriel.32.-32.0.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.32.32.dds", "Textures/terrain/Tamriel/tamriel.32.32.32.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.32.-32.dds", "Textures/terrain/Tamriel/tamriel.32.32.-32.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-32.32.dds", "Textures/terrain/Tamriel/tamriel.32.-32.32.dds");			
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.32.-64.dds", "Textures/terrain/Tamriel/tamriel.32.32.-64.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-32.-64.dds", "Textures/terrain/Tamriel/tamriel.32.-32.-64.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-64.0.dds", "Textures/terrain/Tamriel/tamriel.32.-64.0.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-64.32.dds", "Textures/terrain/Tamriel/tamriel.32.-64.32.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-64.-32.dds", "Textures/terrain/Tamriel/tamriel.32.-64.-32.dds");
			CopyDataFile("Map Standard All Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-64.-64.dds", "Textures/terrain/Tamriel/tamriel.32.-64.-64.dds");
			} 		
		if (categorySelected == 32) {//Standard MAIN ROADS HiRes
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.0.0.dds", "Textures/terrain/Tamriel/tamriel.32.0.0.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.0.-32.dds", "Textures/terrain/Tamriel/tamriel.32.0.-32.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-32.-32.dds", "Textures/terrain/Tamriel/tamriel.32.-32.-32.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.0.32.dds", "Textures/terrain/Tamriel/tamriel.32.0.32.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.0.-32.dds", "Textures/terrain/Tamriel/tamriel.32.0.-32.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.0.-64.dds", "Textures/terrain/Tamriel/tamriel.32.0.-64.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.32.0.dds", "Textures/terrain/Tamriel/tamriel.32.32.0.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-32.0.dds", "Textures/terrain/Tamriel/tamriel.32.-32.0.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.32.32.dds", "Textures/terrain/Tamriel/tamriel.32.32.32.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.32.-32.dds", "Textures/terrain/Tamriel/tamriel.32.32.-32.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-32.32.dds", "Textures/terrain/Tamriel/tamriel.32.-32.32.dds");		
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.32.-64.dds", "Textures/terrain/Tamriel/tamriel.32.32.-64.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-32.-64.dds", "Textures/terrain/Tamriel/tamriel.32.-32.-64.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-64.0.dds", "Textures/terrain/Tamriel/tamriel.32.-64.0.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-64.32.dds", "Textures/terrain/Tamriel/tamriel.32.-64.32.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-64.-32.dds", "Textures/terrain/Tamriel/tamriel.32.-64.-32.dds");
			CopyDataFile("Map Standard Main Roads - HiRes/Textures/terrain/Tamriel/tamriel.32.-64.-64.dds", "Textures/terrain/Tamriel/tamriel.32.-64.-64.dds");
			} 
			
		if (cloudSelected == 42) {//Clear Map add-on    
			CopyDataFile("Optional Clear Map/meshes/sky/skyrimworldmapcloudbank.nif", "meshes/sky/skyrimworldmapcloudbank.nif");
			CopyDataFile("Optional Clear Map/textures/sky/skyrimcloudlut.dds", "textures/sky/skyrimcloudlut.dds");
			} 
	}
	static void installReadmeFiles() {
			CopyDataFile("Readmes/Readme - A Quality World Map.txt", "Readmes/Readme - A Quality World Map.txt");
			CopyDataFile("Readmes/Changlog - A Quality World Map.txt", "Readmes/Changlog - A Quality World Map.txt");
	}
//------------------------------------------------------------------
//Build Formain
//------------------------------------------------------------------	
	static void InitializeComponents(){
		InitializeAudio();		
		InitializeImages();		
		InitializeMainForm();
		InitializePreviewFormComponets();
	}
	
	static void InitializeMainForm() {		
		InitializeBackground();
		InitializePreviewButton(); 	
		InitializeInstallButton(); 	
		InitializeExitButton();		
		SetupMainWindow();
	}

	static void SetupMainWindow() {		
		mainInstallForm = CreateCustomForm();		
		mainInstallForm.AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
		mainInstallForm.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
		mainInstallForm.BackColor = System.Drawing.Color.White;
		mainInstallForm.ClientSize = new System.Drawing.Size(515, 735);		
        mainInstallForm.MaximizeBox = false;
		mainInstallForm.MinimizeBox = false;
        mainInstallForm.MaximumSize = new System.Drawing.Size(515, 735);
        mainInstallForm.MinimumSize = new System.Drawing.Size(515, 735);
	
		InitializeCloudsPatchPanel();
		InitializeStandardRoadsPanel();
		InitializeClassicRoadsPanel();
		InitializePatchesPanel();
		
		mainInstallForm.Controls.Add(previewButton);
		mainInstallForm.Controls.Add(installButton);
		mainInstallForm.Controls.Add(exitButton);
		mainInstallForm.Controls.Add(backgroundPicture);
		mainInstallForm.Name = "MainForm";
		mainInstallForm.Text = "A Quality World Map v8.0";
	}

//------------------------------------------------------------------
//Category. Menus
//------------------------------------------------------------------
	static void InitializeStandardRoadsPanel() {
    	installStandardRoadsPanel = new Panel();
        installStandardRoadsPanel.Location = new Point(50, 140);
        installStandardRoadsPanel.Size = new Size(400, 125);
        installStandardRoadsPanel.BackColor = Color.White; //lol
        installStandardRoadsPanel.BorderStyle = BorderStyle.FixedSingle;
        mainInstallForm.Controls.Add(installStandardRoadsPanel);		
//-------------------------------------------------------------------------------		
		installstdAllButton = new System.Windows.Forms.PictureBox();
		if (categorySelected == 1) {
			installstdAllButton.Image = imageChecked;
		} else {
			installstdAllButton.Image = imageUnchecked;
		}
		installstdAllButton.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		installstdAllButton.Location = new System.Drawing.Point(12, 35);
		installstdAllButton.Name = "installstdAllButton";
		installstdAllButton.Size = new System.Drawing.Size(32, 32);
		installstdAllButton.TabIndex = 7;
		installstdAllButton.TabStop = false;
		installstdAllButton.Click += new System.EventHandler(installstdAllButton_Click);	
		installStandardRoadsPanel.Controls.Add(installstdAllButton);
//-------------------------------------------------------------------------------	
		installstdMainButton = new System.Windows.Forms.PictureBox();
		if (categorySelected == 12) {
			installstdMainButton.Image = imageChecked;
		} else {
			installstdMainButton.Image = imageUnchecked;
		}
		installstdMainButton.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		installstdMainButton.Location = new System.Drawing.Point(12, 85);
		installstdMainButton.Name = "installstdMainButton";
		installstdMainButton.Size = new System.Drawing.Size(32, 32);
		installstdMainButton.TabIndex = 7;
		installstdMainButton.TabStop = false;
		installstdMainButton.Click += new System.EventHandler(installstdMainButton_Click);	
		installStandardRoadsPanel.Controls.Add(installstdMainButton);

		standardLabel = new Label();
        standardLabel.Font = new Font("Arial",14, FontStyle.Bold);
        standardLabel.Location = new Point(12, 5);
        standardLabel.AutoSize = true;
        standardLabel.Text = "Quality Map";
        installStandardRoadsPanel.Controls.Add(standardLabel);
		
		stdAllLabel = new Label();
        stdAllLabel.Font = new Font("Arial",12, FontStyle.Bold);
        stdAllLabel.Location = new Point(50, 42);
        stdAllLabel.AutoSize = true;
        stdAllLabel.Text = "Install ALL roads";
        installStandardRoadsPanel.Controls.Add(stdAllLabel);
		
		stdMainLabel = new Label();
        stdMainLabel.Font = new Font("Arial",12, FontStyle.Bold);
        stdMainLabel.Location = new Point(50, 92);
        stdMainLabel.AutoSize = true;
        stdMainLabel.Text = "Install main roads ONLY";
        installStandardRoadsPanel.Controls.Add(stdMainLabel);
	}		
	static void InitializeClassicRoadsPanel() {
    	installClassicRoadsPanel = new Panel();
        installClassicRoadsPanel.Location = new Point(50, 390);
        installClassicRoadsPanel.Size = new Size(400, 125);
        installClassicRoadsPanel.BackColor = Color.Transparent;
        installClassicRoadsPanel.BorderStyle = BorderStyle.FixedSingle;
        mainInstallForm.Controls.Add(installClassicRoadsPanel);
//-------------------------------------------------------------------------------	
		installclsAllButton = new System.Windows.Forms.PictureBox();
		if (categorySelected == 2) {
			installclsAllButton.Image = imageChecked;
		} else {
			installclsAllButton.Image = imageUnchecked;
		}
		installclsAllButton.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		installclsAllButton.Location = new System.Drawing.Point(12, 35);
		installclsAllButton.Name = "installclsAllButton";
		installclsAllButton.Size = new System.Drawing.Size(32, 32);
		installclsAllButton.TabIndex = 9;
		installclsAllButton.TabStop = false;
		installclsAllButton.Click += new System.EventHandler(installclsAllButton_Click);	
		installClassicRoadsPanel.Controls.Add(installclsAllButton);
//-------------------------------------------------------------------------------
		installclsMainButton = new System.Windows.Forms.PictureBox();
		if (categorySelected == 22) {
			installclsMainButton.Image = imageChecked;
		} else {
			installclsMainButton.Image = imageUnchecked;
		}
		installclsMainButton.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		installclsMainButton.Location = new System.Drawing.Point(12, 85);
		installclsMainButton.Name = "installclsMainButton";
		installclsMainButton.Size = new System.Drawing.Size(32, 32);
		installclsMainButton.TabIndex = 9;
		installclsMainButton.TabStop = false;
		installclsMainButton.Click += new System.EventHandler(installclsMainButton_Click);	
		installClassicRoadsPanel.Controls.Add(installclsMainButton);

		
		classicLabel  = new Label();
        classicLabel.Font = new Font("Arial",14, FontStyle.Bold);
        classicLabel.Location = new Point(12, 5);
        classicLabel.AutoSize = true;
        classicLabel.Text = "Classic Map (Work in Progress)";
        installClassicRoadsPanel.Controls.Add(classicLabel);
	
		clsAllLabel = new Label();
        clsAllLabel.Font = new Font("Arial",12, FontStyle.Bold);
        clsAllLabel.Location = new Point(50, 42);
        clsAllLabel.AutoSize = true;
        clsAllLabel.Text = "Install ALL roads";
        installClassicRoadsPanel.Controls.Add(clsAllLabel);
		
		clsMainLabel = new Label();
        clsMainLabel.Font = new Font("Arial",12, FontStyle.Bold);
        clsMainLabel.Location = new Point(50, 92);
        clsMainLabel.AutoSize = true;
        clsMainLabel.Text = "Install main roads ONLY";
        installClassicRoadsPanel.Controls.Add(clsMainLabel);
	}
	static void InitializePatchesPanel() {
    	installPatchesPanel = new Panel();
        installPatchesPanel.Location = new Point(50, 265); //400
        installPatchesPanel.Size = new Size(400, 125);
        installPatchesPanel.BackColor = Color.Transparent;
        installPatchesPanel.BorderStyle = BorderStyle.FixedSingle;
        mainInstallForm.Controls.Add(installPatchesPanel);
//-------------------------------------------------------------------------------	
		patchNoButton = new System.Windows.Forms.PictureBox(); //NO
		if (categorySelected == 3) {
			patchNoButton.Image = imageChecked;
		} else {
			patchNoButton.Image = imageUnchecked;
		}
		patchNoButton.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		patchNoButton.Location = new System.Drawing.Point(12, 35);
		patchNoButton.Name = "patchNoButton";
		patchNoButton.Size = new System.Drawing.Size(32, 32);
		patchNoButton.TabIndex = 11;
		patchNoButton.TabStop = false;
		patchNoButton.Click += new System.EventHandler(patchNoButton_Click);
		installPatchesPanel.Controls.Add(patchNoButton);

		patchYesButton = new System.Windows.Forms.PictureBox(); //YES
		if (categorySelected == 32) {
			patchYesButton.Image = imageChecked;
		} else {
			patchYesButton.Image = imageUnchecked;
		}		
		patchYesButton.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		patchYesButton.Location = new System.Drawing.Point(12, 80);
		patchYesButton.Name = "patchYesButton";
		patchYesButton.Size = new System.Drawing.Size(32, 32);
		patchYesButton.TabIndex = 11;
		patchYesButton.TabStop = false;
		patchYesButton.Click += new System.EventHandler(patchYesButton_Click);
		installPatchesPanel.Controls.Add(patchYesButton);
		
		patchesLabel  = new Label();
        patchesLabel.Font = new Font("Arial",14, FontStyle.Bold);
        patchesLabel.Location = new Point(12, 5);
        patchesLabel.AutoSize = true;
        patchesLabel.Text = "Quality Map (HiRes)";
        installPatchesPanel.Controls.Add(patchesLabel);
	
		patchNoLabel = new Label();
        patchNoLabel.Font = new Font("Arial",12, FontStyle.Bold);//,FontStyle.Bold
        patchNoLabel.Location = new Point(50, 42);
        patchNoLabel.AutoSize = true;
        patchNoLabel.Text = "Install All Roads";
        installPatchesPanel.Controls.Add(patchNoLabel);
		
		patchYesLabel = new Label();
        patchYesLabel.Font = new Font("Arial",12, FontStyle.Bold);//,FontStyle.Bold
        patchYesLabel.Location = new Point(50, 89);
        patchYesLabel.AutoSize = true;
        patchYesLabel.Text = "Install Main Roads ONLY";
        installPatchesPanel.Controls.Add(patchYesLabel);
	
	}
	static void InitializeCloudsPatchPanel() {
    	installCloudPatchPanel = new Panel();
        installCloudPatchPanel.Location = new Point(50, 515);
        installCloudPatchPanel.Size = new Size(400, 125);
        installCloudPatchPanel.BackColor = Color.Transparent;
        installCloudPatchPanel.BorderStyle = BorderStyle.FixedSingle;
        mainInstallForm.Controls.Add(installCloudPatchPanel);
//-------------------------------------------------------------------------------	
		cloudsNoButton = new System.Windows.Forms.PictureBox(); //NO
		if (cloudSelected == 4) {
			cloudsNoButton.Image = imageChecked;
		} else {
			cloudsNoButton.Image = imageUnchecked;
		}
		cloudsNoButton.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		cloudsNoButton.Location = new System.Drawing.Point(12, 35);
		cloudsNoButton.Name = "cloudsNoButton";
		cloudsNoButton.Size = new System.Drawing.Size(32, 32);
		cloudsNoButton.TabIndex = 11;
		cloudsNoButton.TabStop = false;
		cloudsNoButton.Click += new System.EventHandler(cloudNoButton_Click);
		installCloudPatchPanel.Controls.Add(cloudsNoButton);

		cloudsYesButton = new System.Windows.Forms.PictureBox(); //YES
		if (cloudSelected == 42) {
			cloudsYesButton.Image = imageChecked;
		} else {
			cloudsYesButton.Image = imageUnchecked;
		}		
		cloudsYesButton.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		cloudsYesButton.Location = new System.Drawing.Point(12, 80);
		cloudsYesButton.Name = "cloudsYesButton";
		cloudsYesButton.Size = new System.Drawing.Size(32, 32);
		cloudsYesButton.TabIndex = 11;
		cloudsYesButton.TabStop = false;
		cloudsYesButton.Click += new System.EventHandler(cloudYesButton_Click);
		installCloudPatchPanel.Controls.Add(cloudsYesButton);
		
		cloudsLabel  = new Label();
        cloudsLabel.Font = new Font("Arial",14, FontStyle.Bold);
        cloudsLabel.Location = new Point(12, 5);
        cloudsLabel.AutoSize = true;
        cloudsLabel.Text = "Clear Map Add-on";
        installCloudPatchPanel.Controls.Add(cloudsLabel);
	
		cloudsNoLabel = new Label();
        cloudsNoLabel.Font = new Font("Arial",12, FontStyle.Bold);
        cloudsNoLabel.Location = new Point(50, 43);
        cloudsNoLabel.AutoSize = true;
        cloudsNoLabel.Text = "DO NOT install Clear Map Add-on";
        installCloudPatchPanel.Controls.Add(cloudsNoLabel);
		
		cloudsYesLabel = new Label();
        cloudsYesLabel.Font = new Font("Arial",12, FontStyle.Bold);
        cloudsYesLabel.Location = new Point(50, 88);
        cloudsYesLabel.AutoSize = true;
        cloudsYesLabel.Text = "Install Clear Map Add-on";
        installCloudPatchPanel.Controls.Add(cloudsYesLabel);
	
	}
//------------------------------------------------------------------
//Select Install Buttons
//------------------------------------------------------------------	
	static void installstdAllButton_Click(object sender, EventArgs e) {
		selectPlayer.Play();
		installstdAllButton.Image = imageChecked;
		installstdMainButton.Image = imageUnchecked;
		installclsAllButton.Image = imageUnchecked;
		installclsMainButton.Image = imageUnchecked;	
		patchNoButton.Image = imageUnchecked;
		patchYesButton.Image = imageUnchecked;	
		categorySelected = 1;
	}
	static void installstdMainButton_Click(object sender, EventArgs e) {
		selectPlayer.Play();
		installstdAllButton.Image = imageUnchecked;
		installstdMainButton.Image = imageChecked;
		installclsAllButton.Image = imageUnchecked;	
		installclsMainButton.Image = imageUnchecked;
		patchNoButton.Image = imageUnchecked;
		patchYesButton.Image = imageUnchecked;	
		categorySelected = 12;
	}
	
	static void installclsAllButton_Click(object sender, EventArgs e) {
		selectPlayer.Play();
		installstdAllButton.Image = imageUnchecked;
		installstdMainButton.Image = imageUnchecked;
		installclsAllButton.Image = imageChecked;
		installclsMainButton.Image = imageUnchecked;	
		patchNoButton.Image = imageUnchecked;
		patchYesButton.Image = imageUnchecked;	
		categorySelected = 2;
	}
	static void installclsMainButton_Click(object sender, EventArgs e) {
		selectPlayer.Play();
		installstdAllButton.Image = imageUnchecked;
		installstdMainButton.Image = imageUnchecked;
		installclsAllButton.Image = imageUnchecked;
		installclsMainButton.Image = imageChecked;
		patchNoButton.Image = imageUnchecked;
		patchYesButton.Image = imageUnchecked;			
		categorySelected = 22;
	}
	
	static void patchNoButton_Click(object sender, EventArgs e) {//All Roads now = 3
		selectPlayer.Play();
		patchNoButton.Image = imageChecked;
		patchYesButton.Image = imageUnchecked;	
		installstdAllButton.Image = imageUnchecked;
		installstdMainButton.Image = imageUnchecked;
		installclsAllButton.Image = imageUnchecked;
		installclsMainButton.Image = imageUnchecked;		
		//MessageBox("This Hi-Res map option requires the Hi-Res meshes found in Ethatron's High Quality 3D Map mod.  You can find his mod at the Nexus website here: http://skyrim.nexusmods.com/downloads/file.php?id=4817");
		categorySelected = 3;
	}	
	static void patchYesButton_Click(object sender, EventArgs e) {//Main Roads now = 32
		selectPlayer.Play();
		patchNoButton.Image = imageUnchecked;
		patchYesButton.Image = imageChecked;
		installstdAllButton.Image = imageUnchecked;
		installstdMainButton.Image = imageUnchecked;
		installclsAllButton.Image = imageUnchecked;
		installclsMainButton.Image = imageUnchecked;			
	//	MessageBox("This Hi-Res map option requires the Hi-Res meshes found in Ethatron's High Quality 3D Map mod.  You can find his mod at the Nexus website here: http://skyrim.nexusmods.com/downloads/file.php?id=4817");
		categorySelected = 32;
	}
	
	static void cloudNoButton_Click(object sender, EventArgs e) {
		selectPlayer.Play();
		cloudsNoButton.Image = imageChecked;
		cloudsYesButton.Image = imageUnchecked;				
		cloudSelected = 4;
	}
	static void cloudYesButton_Click(object sender, EventArgs e) {
		selectPlayer.Play();
		cloudsNoButton.Image = imageUnchecked;
		cloudsYesButton.Image = imageChecked;			
	//	MessageBox("If you have previously removed the clouds from the map, using the sMapCloudNIF=0 setting in your Skyrim.ini, this add-on will NOT work.  Please delete that setting from your Skyrim.ini if you want to use the Clear Map Add-on.");
		cloudSelected = 42;
	}

// Preview Button
	static void previewButton_MouseEnter(object sender, EventArgs e) {
		previewButton.Image = imagePreviewHi;
		hoverPlayer.Play();
	}
	static void previewButton_MouseLeave(object sender, EventArgs e) {
		previewButton.Image = imagePreview;
	}	
	static void previewButton_Click(object sender, EventArgs e) {
		acceptPlayer.Play();
		previewForm.ShowDialog();
	}

// Install Button	
	static void installButton_MouseEnter(object sender, EventArgs e) {
		installButton.Image = imageInstallHi;
		hoverPlayer.Play();
	}
	static void installButton_MouseLeave(object sender, EventArgs e) {
		installButton.Image = imageInstall;
	}	
	static void installButton_Click(object sender, EventArgs e) {
		acceptPlayer.Play();
		install = true;
		mainInstallForm.Close();
	}	

// Exit Button
	static void exitButton_MouseEnter(object sender, EventArgs e) {
		exitButton.Image = imageExitHi;
		hoverPlayer.Play();
	}
	static void exitButton_MouseLeave(object sender, EventArgs e) {
		exitButton.Image = imageExit;
	}
	static void exitButton_Click(object sender, EventArgs e) {
		denyPlayer.Play();
		mainInstallForm.Close();
	}	

//------------------------------------------------------------------
//Setup Picture Boxes
//------------------------------------------------------------------	
	static void InitializeBackground() {
		backgroundPicture = new System.Windows.Forms.PictureBox();	   
		backgroundPicture.BackColor = System.Drawing.Color.Transparent;
		backgroundPicture.Image = imageBackground;
		backgroundPicture.Location = new System.Drawing.Point(0, 0);
		backgroundPicture.Name = "Background";
		backgroundPicture.Size = new System.Drawing.Size(515, 735);
		backgroundPicture.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		backgroundPicture.TabIndex = 0;
		backgroundPicture.TabStop = false;		
	}
	static void InitializePreviewButton() {
		previewButton = new System.Windows.Forms.PictureBox();
		previewButton.Anchor = System.Windows.Forms.AnchorStyles.None;
		previewButton.Image = imagePreview;
		previewButton.Location = new System.Drawing.Point(5, 645);
		previewButton.Name = "previewButton";
		previewButton.Size = new System.Drawing.Size(129, 46);
		previewButton.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		previewButton.TabIndex = 3;
		previewButton.TabStop = false;
		previewButton.Click += new System.EventHandler(previewButton_Click);
		previewButton.MouseEnter += new System.EventHandler(previewButton_MouseEnter);
		previewButton.MouseLeave += new System.EventHandler(previewButton_MouseLeave);	   
	}	
	static void InitializeInstallButton() {
		installButton = new System.Windows.Forms.PictureBox();
		installButton.Anchor = System.Windows.Forms.AnchorStyles.None;
		installButton.Image = imageInstall;
		installButton.Location = new System.Drawing.Point(185, 645);
		installButton.Name = "installButton";
		installButton.Size = new System.Drawing.Size(129, 46);
		installButton.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		installButton.TabIndex = 3;
		installButton.TabStop = false;
		installButton.Click += new System.EventHandler(installButton_Click);
		installButton.MouseEnter += new System.EventHandler(installButton_MouseEnter);
		installButton.MouseLeave += new System.EventHandler(installButton_MouseLeave);	   
	}
	static void InitializeExitButton() {
		exitButton = new System.Windows.Forms.PictureBox();
		exitButton.Image = imageExit;
		exitButton.Location = new System.Drawing.Point(365, 645);
		exitButton.Name = "exitButton";
		exitButton.Size = new System.Drawing.Size(129, 46);
		exitButton.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		exitButton.TabIndex = 2;
		exitButton.TabStop = false;
		exitButton.Click += new System.EventHandler(exitButton_Click);
		exitButton.MouseEnter += new System.EventHandler(exitButton_MouseEnter);
		exitButton.MouseLeave += new System.EventHandler(exitButton_MouseLeave);	   
	}
	static void InitializeImages() {	
		InitializeCommonImages();
		InitializeMainImages();
	}

	
//------------------------------------------------------------------
//Preview Form
//------------------------------------------------------------------		
	static void InitializePreviewFormComponets() {
		SetupPreviewForm();
	}	
	static void SetupPreviewForm() {		
		previewForm = CreateCustomForm();
		previewForm.AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
		previewForm.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
		previewForm.BackColor = System.Drawing.Color.Black;
		previewForm.ClientSize = new System.Drawing.Size(1200, 750);
		
		previewForm.Controls.Add(backButton);
		SetupPreviewPanelMenu();
		InitializepreviewMapBox();
	
	
		previewForm.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
		previewForm.Name = "previewForm";
		previewForm.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
		previewForm.Text = "Selection Preview";
	}	
	static void SetupPreviewPanelMenu() {
    	previewPanel = new Panel();
        previewPanel.Location = new Point(830, 485);
        previewPanel.Size = new Size(350, 245);
        previewPanel.BackColor = Color.White;
        previewPanel.BorderStyle = BorderStyle.FixedSingle;
        previewForm.Controls.Add(previewPanel);
		
		
		
		previewVanillaMap = new System.Windows.Forms.PictureBox();
		if (previewSelected == 1) {
			previewVanillaMap.Image = imageChecked;		
		} else {
			previewVanillaMap.Image = imageUnchecked;
		}
		previewVanillaMap.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		previewVanillaMap.Location = new System.Drawing.Point(5, 5); //37*x+5=Yaxis
		previewVanillaMap.Name = "previewVanillaMap";
		previewVanillaMap.Size = new System.Drawing.Size(32, 32);
		previewVanillaMap.TabIndex = 7;
		previewVanillaMap.TabStop = false;
		previewVanillaMap.Click += new System.EventHandler(previewVanillaMap_Click);	
		previewPanel.Controls.Add(previewVanillaMap);

		previewVanillaMapLabel = new Label();
        previewVanillaMapLabel.Font = new Font("Arial",12, FontStyle.Bold);
        previewVanillaMapLabel.Location = new Point(42, 10);
        previewVanillaMapLabel.AutoSize = true;
        previewVanillaMapLabel.Text = "Preview Vanilla Map";
        previewPanel.Controls.Add(previewVanillaMapLabel);

		
		previewAllRoadsMap = new System.Windows.Forms.PictureBox();
		if (previewSelected == 2) {
			previewAllRoadsMap.Image = imageChecked;
		} else {
			previewAllRoadsMap.Image = imageUnchecked;
		}
		previewAllRoadsMap.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		previewAllRoadsMap.Location = new System.Drawing.Point(5, 42);
		previewAllRoadsMap.Name = "previewVanillaMap";
		previewAllRoadsMap.Size = new System.Drawing.Size(32, 32);
		previewAllRoadsMap.TabIndex = 7;
		previewAllRoadsMap.TabStop = false;
		previewAllRoadsMap.Click += new System.EventHandler(previewAllRoadsMap_Click);	
		previewPanel.Controls.Add(previewAllRoadsMap);

		previewAllRoadsMapLabel = new Label();
        previewAllRoadsMapLabel.Font = new Font("Arial",12, FontStyle.Bold);
        previewAllRoadsMapLabel.Location = new Point(42, 47);
        previewAllRoadsMapLabel.AutoSize = true;
        previewAllRoadsMapLabel.Text = "Preview Standard All Roads Map";
        previewPanel.Controls.Add(previewAllRoadsMapLabel);
		
		previewMainRoadsMap = new System.Windows.Forms.PictureBox();
		if (previewSelected == 3) {
			previewMainRoadsMap.Image = imageChecked;
			//		previewMapBox.Image = imageVanillaMap;
		} else {
			previewMainRoadsMap.Image = imageUnchecked;
		}
		previewMainRoadsMap.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		previewMainRoadsMap.Location = new System.Drawing.Point(5, 79);
		previewMainRoadsMap.Name = "previewMainRoadsMap";
		previewMainRoadsMap.Size = new System.Drawing.Size(32, 32);
		previewMainRoadsMap.TabIndex = 7;
		previewMainRoadsMap.TabStop = false;
		previewMainRoadsMap.Click += new System.EventHandler(previewMainRoadsMap_Click);	
		previewPanel.Controls.Add(previewMainRoadsMap);

		previewMainRoadsMapLabel = new Label();
        previewMainRoadsMapLabel.Font = new Font("Arial",12, FontStyle.Bold);
        previewMainRoadsMapLabel.Location = new Point(42, 84);
        previewMainRoadsMapLabel.AutoSize = true;
        previewMainRoadsMapLabel.Text = "Preview Standard Main Roads Map";
        previewPanel.Controls.Add(previewMainRoadsMapLabel);
		
		previewClassicMap = new System.Windows.Forms.PictureBox();
		if (previewSelected == 4) {
			previewClassicMap.Image = imageChecked;
		} else {
			previewClassicMap.Image = imageUnchecked;
		}
		previewClassicMap.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		previewClassicMap.Location = new System.Drawing.Point(5, 116);
		previewClassicMap.Name = "previewClassicMap";
		previewClassicMap.Size = new System.Drawing.Size(32, 32);
		previewClassicMap.TabIndex = 7;
		previewClassicMap.TabStop = false;
		previewClassicMap.Click += new System.EventHandler(previewClassicMap_Click);	
		previewPanel.Controls.Add(previewClassicMap);

		previewClassicMapLabel = new Label();
        previewClassicMapLabel.Font = new Font("Arial",12, FontStyle.Bold);
        previewClassicMapLabel.Location = new Point(42, 121);
        previewClassicMapLabel.AutoSize = true;
        previewClassicMapLabel.Text = "Preview Classic Map";
        previewPanel.Controls.Add(previewClassicMapLabel);
		
		previewVanillaClouds = new System.Windows.Forms.PictureBox();
		if (previewSelected == 5) {
			previewVanillaClouds.Image = imageChecked;
		} else {
			previewVanillaClouds.Image = imageUnchecked;
		}
		previewVanillaClouds.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		previewVanillaClouds.Location = new System.Drawing.Point(5, 153);
		previewVanillaClouds.Name = "previewVanillaClouds";
		previewVanillaClouds.Size = new System.Drawing.Size(32, 32);
		previewVanillaClouds.TabIndex = 7;
		previewVanillaClouds.TabStop = false;
		previewVanillaClouds.Click += new System.EventHandler(previewVanillaClouds_Click);	
		previewPanel.Controls.Add(previewVanillaClouds);

		previewVanillaCloudsLabel = new Label();
        previewVanillaCloudsLabel.Font = new Font("Arial",12, FontStyle.Bold);
        previewVanillaCloudsLabel.Location = new Point(42, 158);
        previewVanillaCloudsLabel.AutoSize = true;
        previewVanillaCloudsLabel.Text = "Preview without Clear Map Add-on";
        previewPanel.Controls.Add(previewVanillaCloudsLabel);
		
		previewClearMap = new System.Windows.Forms.PictureBox();
		if (previewSelected == 6) {
			previewClearMap.Image = imageChecked;
		} else {
			previewClearMap.Image = imageUnchecked;
		}
		previewClearMap.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		previewClearMap.Location = new System.Drawing.Point(5, 190);
		previewClearMap.Name = "previewClearMap";
		previewClearMap.Size = new System.Drawing.Size(32, 32);
		previewClearMap.TabIndex = 7;
		previewClearMap.TabStop = false;
		previewClearMap.Click += new System.EventHandler(previewClearMap_Click);	
		previewPanel.Controls.Add(previewClearMap);	

		previewClearMapLabel = new Label();
        previewClearMapLabel.Font = new Font("Arial",12, FontStyle.Bold);
        previewClearMapLabel.Location = new Point(42, 195);
        previewClearMapLabel.AutoSize = true;
        previewClearMapLabel.Text = "Preview with Clear Map Add-on";
        previewPanel.Controls.Add(previewClearMapLabel);
		
		backButton = new System.Windows.Forms.PictureBox();
		backButton.Image = imageBack;
		backButton.Location = new System.Drawing.Point(20, 690);
		backButton.Name = "backButton";
		backButton.Size = new System.Drawing.Size(129, 46);
		backButton.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		backButton.TabIndex = 2;
		backButton.TabStop = false;
		backButton.Click += new System.EventHandler(backButton_Click);
		backButton.MouseEnter += new System.EventHandler(backButton_MouseEnter);
		backButton.MouseLeave += new System.EventHandler(backButton_MouseLeave);
		previewForm.Controls.Add(backButton);
	}//end preview panel	
	static void InitializepreviewMapBox() {
		previewMapBox = new System.Windows.Forms.PictureBox();
		previewMapBox.SizeMode = System.Windows.Forms.PictureBoxSizeMode.Zoom;
		previewMapBox.BackColor = System.Drawing.Color.Transparent;
		previewMapBox.Image = imageVanillaMap; //default setting
		previewMapBox.Location = new System.Drawing.Point(0, 0);
		previewMapBox.Name = "preview window";
		previewMapBox.Size = new System.Drawing.Size(1200, 750);
		previewMapBox.TabIndex = 7;
		previewMapBox.TabStop = false;	
		previewForm.Controls.Add(previewMapBox);
	}
	
	
//------------------------------------------------------------------
//Select Preview Buttons
//------------------------------------------------------------------
	static void previewVanillaMap_Click(object sender, EventArgs e) {
		selectPlayer.Play();
		previewVanillaMap.Image = imageChecked;
		previewAllRoadsMap.Image = imageUnchecked;
		previewMainRoadsMap.Image = imageUnchecked;
		previewClassicMap.Image = imageUnchecked;
		previewVanillaClouds.Image = imageUnchecked;
		previewClearMap.Image = imageUnchecked;	
		previewMapBox.Image = imageVanillaMap;		
		previewSelected = 1;
	}	
	static void previewAllRoadsMap_Click(object sender, EventArgs e) {
		selectPlayer.Play();
		previewVanillaMap.Image = imageUnchecked;
		previewAllRoadsMap.Image = imageChecked;
		previewMainRoadsMap.Image = imageUnchecked;
		previewClassicMap.Image = imageUnchecked;
		previewVanillaClouds.Image = imageUnchecked;
		previewClearMap.Image = imageUnchecked;	
		previewMapBox.Image = imageAllRoads;		
		previewSelected = 2;
	}		
	static void previewMainRoadsMap_Click(object sender, EventArgs e) {
		selectPlayer.Play();
		previewVanillaMap.Image = imageUnchecked;
		previewAllRoadsMap.Image = imageUnchecked;
		previewMainRoadsMap.Image = imageChecked;
		previewClassicMap.Image = imageUnchecked;
		previewVanillaClouds.Image = imageUnchecked;
		previewClearMap.Image = imageUnchecked;	
		previewMapBox.Image = imageMainRoads;		
		previewSelected = 3;
	}	
	static void previewClassicMap_Click(object sender, EventArgs e) {
		selectPlayer.Play();
		previewVanillaMap.Image = imageUnchecked;
		previewAllRoadsMap.Image = imageUnchecked;
		previewMainRoadsMap.Image = imageUnchecked;
		previewClassicMap.Image = imageChecked;
		previewVanillaClouds.Image = imageUnchecked;
		previewClearMap.Image = imageUnchecked;	
		previewMapBox.Image = imageClassicMap;		
		previewSelected = 4;
	}	
	static void previewVanillaClouds_Click(object sender, EventArgs e) {
		selectPlayer.Play();
		previewVanillaMap.Image = imageUnchecked;
		previewAllRoadsMap.Image = imageUnchecked;
		previewMainRoadsMap.Image = imageUnchecked;
		previewClassicMap.Image = imageUnchecked;
		previewVanillaClouds.Image = imageChecked;
		previewClearMap.Image = imageUnchecked;	
		previewMapBox.Image = imageVanillaClouds;		
		previewSelected = 5;
	}	
	static void previewClearMap_Click(object sender, EventArgs e) {
		selectPlayer.Play();
		previewVanillaMap.Image = imageUnchecked;
		previewAllRoadsMap.Image = imageUnchecked;
		previewMainRoadsMap.Image = imageUnchecked;
		previewClassicMap.Image = imageUnchecked;
		previewVanillaClouds.Image = imageUnchecked;
		previewClearMap.Image = imageChecked;	
		previewMapBox.Image = imageClearMap;	
		previewSelected = 6;
	}	

// Back Button
	static void backButton_MouseEnter(object sender, EventArgs e) {
		backButton.Image = imageBackHi;
		hoverPlayer.Play();
	}
	static void backButton_MouseLeave(object sender, EventArgs e) {
		backButton.Image = imageBack;
	}
	static void backButton_Click(object sender, EventArgs e) {
		denyPlayer.Play();
		previewForm.Close();
	}	
	
//------------------------------------------------------------------
//Asset File Paths
//------------------------------------------------------------------	
	static void InitializeCommonImages() {	
		imageChecked = GetImageFromFomod("fomod/InstallerChecked.png");
		imageUnchecked = GetImageFromFomod("fomod/InstallerUnchecked.png");
	}	
	static void InitializeMainImages() {	
		imageBackground = GetImageFromFomod("fomod/Background.png");
		imageInstall = GetImageFromFomod("fomod/Install.png");
		imageInstallHi = GetImageFromFomod("fomod/InstallHi.png");
		imageExit = GetImageFromFomod("fomod/Exit.png");
		imageExitHi = GetImageFromFomod("fomod/ExitHi.png");
		imagePreview = GetImageFromFomod("fomod/PreviewButton.png"); 
		imagePreviewHi = GetImageFromFomod("fomod/PreviewButtonHi.png");
	
		imageVanillaMap = GetImageFromFomod("fomod/Preview/VanillaPreview.jpg");
		imageAllRoads = GetImageFromFomod("fomod/Preview/AllRoadsPreview.jpg");
		imageMainRoads = GetImageFromFomod("fomod/Preview/MainRoadsPreview.jpg");
		imageVanillaClouds = GetImageFromFomod("fomod/Preview/NoCloudsPreview.jpg");
		imageClearMap = GetImageFromFomod("fomod/Preview/CloudsPreview.jpg");
		imageClassicMap = GetImageFromFomod("fomod/Preview/ClassicMapPreview.jpg");
		imageBack = GetImageFromFomod("fomod/Back.png");
		imageBackHi = GetImageFromFomod("fomod/BackHi.png");
	}
	static void InitializeAudio() {
		hoverPlayer = new System.Media.SoundPlayer();
		acceptPlayer = new System.Media.SoundPlayer();
		denyPlayer = new System.Media.SoundPlayer();
		selectPlayer = new System.Media.SoundPlayer();
	
		hoverPlayer.Stream = GetStreamFromFomod("fomod/ui_menu_focus.wav");
		acceptPlayer.Stream = GetStreamFromFomod("fomod/ui_menu_ok.wav");
		denyPlayer.Stream = GetStreamFromFomod("fomod/ui_menu_cancel.wav");
		selectPlayer.Stream = GetStreamFromFomod("fomod/ui_menu_prevnext.wav");
	}

//------------------------------------------------------------------
//Memory Buffers ?
//------------------------------------------------------------------	
	static bool IsPluginActive(String pluginName) {  	
		string[] loadOrder = GetActivePlugins();  
		for (int i = 0; i < loadOrder.Length; ++i) {  
			if (loadOrder[i].Equals(pluginName, StringComparison.InvariantCultureIgnoreCase)) {
				 return true;  
			}
		}  	
		return false;  
	}   
	static Image GetImageFromFomod(string filename) {  
		byte[] data = GetFileFromFomod(filename);  
		MemoryStream s = new MemoryStream(data);  
		Image img = Image.FromStream(s);  
		s.Close();  		
		return img;  
	} 
	static Stream GetStreamFromFomod(string filename) {  
		byte[] data = GetFileFromFomod(filename);	
		if (data == null)
			return null;			
		return new MemoryStream(data);
	}

}//happy ending
//Big thanks to schlangster and the rest of the Nexus mod community !




